# --------------------------
# --------------------------
# Figure 4: Edge/area ratio development
# --------------------------
# --------------------------

rootDirectory = '' # YOU must set this!

rdaInputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figures 3 & 4 - Edge-area-ratio/RDA', sep = '')
figureOutputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figures 3 & 4 - Edge-area-ratio', sep = '')
functionDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Functions', sep = '')
source(paste(functionDirectory,'callFunctions.R', sep = ''))
callFunctions(functionDirectory)

library(raster)
library(scales)

## --------------------------
## Create initial vegetation patterns
## --------------------------
# matrixLength = 100
# gravitySeq = c(-5,-1,0,1,3,5,10)
# n_grids = length(gravitySeq)
# 
# set.seed(1)
# MiSeries = array(NA, dim = c(matrixLength,matrixLength, n_grids))
# for(i_run in 1:n_runs){
#   for(i_grid in 1:n_grids){
#     MiSeries[,,i_grid] = initialPatchMaker_v2(matrixLength = matrixLength, patchNumber = 1000, patchSizeVariance = 0, gravity = gravitySeq[i_grid])
#     plot(raster::raster(MiSeries[,,i_grid]), box = F, axes = F, legend = F)
#   }
# }
# 
# setwd(rdaInputDirectory)
# save(MiSeries, file = 'Figure4_grids.rda')
 
## ---------- ##
## ---------- ##
#  SIMULATIONS #
## ---------- ##
## ---------- ##
#
## ------------------------
# setwd(rdaInputDirectory)
# load('Figure4_grids.rda')
#
#
## ----------
## ----------
## PANEL 4A
## ----------
## ----------
#
## ----------
## Rum simulation - Figure 2a
## ----------
# tf = 1750
# n_grids = 7
# EdgeArea.ratio = Area = Edge = array(NA, dim = c(tf,n_grids))
# M = array(NA, dim = c(matrixLength,matrixLength, tf,n_grids))
# for(i_grid in 1:n_grids){
#   
#   M[,,1,i_grid] = MiSeries[,,i_grid]
#   
#   # Run simulations
#   patchArea = 0.1
#   t = 1
#   while(patchArea > 0 & patchArea < 1 & t < tf){
#     M[,,t + 1,i_grid] = monteCarlo(M = M[,,t,i_grid], 
#                                          disturbanceSize = 0, 
#                                          growthRate = 0.01)
#     patchArea = sum(M[,,t + 1,i_grid])/matrixLength^2
#     t = t + 1
#   }
#   
#   edgeM = areaM = array(NA, dim = dim(M)[1:3])
#   for(t in 1:dim(M)[3]){
#     areaM[,,t] = round(M[,,t,i_grid])
#     edgeM[,,t] = edgeFind(areaM[,,t])
#   }
#   Edge[,i_grid] = apply(edgeM,3,mean)
#   Area[,i_grid] = apply(areaM,3,mean)
#   EdgeArea.ratio[,i_grid] = Edge[,i_grid]/Area[,i_grid]
#   
# }
# EA = apply(EdgeArea.ratio, c(1,2),mean)
# A = apply(Area, c(1,2),mean)
# 
# setwd(rdaInputDirectory)
# save(EA, file = 'Figure4a_EdgeAreaRatio_trial.rda')
# save(A, file = 'Figure4a_VegetationCover_trial.rda')
# save(M, file = 'Figure4a_trial.rda')

## ----------
## ----------
## PANEL 4B
## ----------
## ----------
#
## ------------------
## Plot Figure 4b - Main panel
## -------------------
# 
# tf = 1750
# disturbanceMoment = 0.66
# disturbanceIntensity = 0.8
# 
# colRB = alpha(colorRampPalette(c("blue",'red'))(n_grids),0.5)
# par(mar = c(5,5,4,4))
# plot(c(1), ylim = c(0.001,1), xlim = c(0,1), type = 'n', 
#      ylab = 'Edge / Area ratio', xlab = 'Total cover (proportion)', 
#      log = '', cex.lab = 1.3, cex.axis = 1.2)
# 
# lines(x = c(disturbanceMoment,disturbanceMoment), y = c(0,1))
# 
# EdgeArea.ratio = roundArea = Area = Edge = array(NA, dim = c(tf,n_grids))
# M = array(NA, dim = c(matrixLength,matrixLength, tf,n_grids))
# for(i_grid in 1:n_grids){
#   noDisturbanceYet = T
#   
#   M[,,1,i_grid] = MiSeries[,,i_grid]
#   # Run simulations
#   patchArea = 0.1
#   t = 1
#   while(patchArea > 0 & patchArea < 1 & t < tf){
#     
#     if(patchArea > disturbanceMoment & noDisturbanceYet == T){
#       # SCHEDULED DISTURBANCE
#       noDisturbanceYet = F
#       
#       M[,,t + 1,i_grid] = M[,,t,i_grid]
#       neighbors = rollMatrix(M[,,t + 1,i_grid], n_directions = 8, operation = 'sum')
#       resistance = (M[,,t + 1,i_grid] + neighbors)/9
#       mortality = resistance < disturbanceIntensity
#       M[,,t + 1,i_grid][mortality] = 0
#       patchArea = sum(round(M[,,t + 1,i_grid]))/matrixLength^2
# 
#     } else {
#       # NORMAL GROWTH
#       M[,,t + 1,i_grid] = monteCarlo(M = M[,,t,i_grid], 
#                                      disturbanceSize = 0, 
#                                      growthRate = 0.01)
#       patchArea = sum(round(M[,,t + 1,i_grid]))/matrixLength^2
#     }
#     t = t + 1
#   }
#   edgeM = areaM = array(NA, dim = dim(M)[1:3])
#   for(t in 1:dim(M)[3]){
#     areaM[,,t] = round(M[,,t,i_grid])
#     edgeM[,,t] = edgeFind(areaM[,,t])
#   }
#   Edge[,i_grid] = apply(edgeM,3,mean)
#   Area[,i_grid] = apply(areaM,3,mean)
#   EdgeArea.ratio[,i_grid] = Edge[,i_grid]/Area[,i_grid]
#   
#   lines(EdgeArea.ratio[,i_grid] ~ Area[,i_grid], lwd = 2, col = colRB[i_grid])
# }
# 
# EA3 = apply(EdgeArea.ratio, c(1,2),mean)
# A3 = apply(Area, c(1,2),mean)
# 
# setwd(rdaInputDirectory)
# save(M, file = 'Figure4b_trial.rda')
# save(EA3, file = 'Figure4b_EdgeAreaRatio_trial.rda')
# save(A3, file = 'Figure4b_VegetationCover_trial.rda')

## ----------
## ----------
## PANEL 4C
## ----------
## ----------
#
## ----------
## Rum simulation - Figure 4c
## ----------
# 
# tf = 1750
# disturbanceMoment = 0.33
# disturbanceIntensity = 0.8
# 
# colRB = alpha(colorRampPalette(c("blue",'red'))(n_grids),0.5)
# par(mar = c(5,5,4,4))
# plot(c(1), ylim = c(0.001,1), xlim = c(0,1), type = 'n',
#      ylab = 'Edge / Area ratio', xlab = 'Total cover (proportion)',
#      log = '', cex.lab = 1.3, cex.axis = 1.2)
# lines(x = c(disturbanceMoment,disturbanceMoment), y = c(0,1))
# 
# EdgeArea.ratio = Area = array(NA, dim = c(tf,n_grids))
# M = array(NA, dim = c(matrixLength,matrixLength, tf,n_grids))
# for(i_grid in 1:n_grids){
#   noDisturbanceYet = T
#   
#   M[,,1,i_grid] = MiSeries[,,i_grid]
#   # Run simulations
#   patchArea = 0.1
#   t = 1
#   while(patchArea > 0 & patchArea < 1 & t < tf){
#     
#    
#     if(patchArea > disturbanceMoment & noDisturbanceYet == T){
#       # SCHEDULED DISTURBANCE
#       noDisturbanceYet = F
#       
#       M[,,t + 1,i_grid] = M[,,t,i_grid]
#       neighbors = rollMatrix(M[,,t + 1,i_grid], n_directions = 8, operation = 'sum')
#       resistance = (M[,,t + 1,i_grid] + neighbors)/9
#       mortality = resistance < disturbanceIntensity
#       M[,,t + 1,i_grid][mortality] = 0
#       patchArea = sum(round(M[,,t + 1,i_grid]))/matrixLength^2
# 
#     } else {
#       # NORMAL GROWTH
#       M[,,t + 1,i_grid] = monteCarlo(M = M[,,t,i_grid], 
#                                      disturbanceSize = 0, 
#                                      growthRate = 0.01)
#       patchArea = sum(round(M[,,t + 1,i_grid]))/matrixLength^2
#     }
#     t = t + 1
#   }
#   edgeM = areaM = array(NA, dim = dim(M)[1:3])
#   for(t in 1:dim(M)[3]){
#     areaM[,,t] = round(M[,,t,i_grid])
#     edgeM[,,t] = edgeFind(areaM[,,t])
#   }
#   Edge[,i_grid] = apply(edgeM,3,mean)
#   Area[,i_grid] = apply(areaM,3,mean)
#   EdgeArea.ratio[,i_grid] = Edge[,i_grid]/Area[,i_grid]
#   
#   lines(EdgeArea.ratio[,i_grid] ~ Area[,i_grid], lwd = 2, col = colRB[i_grid])
# }
# EA3 = apply(EdgeArea.ratio, c(1,2),mean)
# A3 = apply(Area, c(1,2),mean)
# 
# setwd(rdaInputDirectory)
# save(M, file = 'Figure4c_trial.rda')
# save(EA2, file = 'Figure4c_EdgeAreaRatio_trial.rda')
# save(A2, file = 'Figure4c_VegetationCover_trial.rda')


## ---------- ##
## ---------- ##
#   PLOTTING   #
## ---------- ##
## ---------- ##

# ------------------
# Load results of simulation - Figure 4a 
# -------------------
setwd(rdaInputDirectory)
load('Figure4a_trial.rda')
load('Figure4a_EdgeAreaRatio_trial.rda')
load('Figure4a_VegetationCover_trial.rda')

# ------------------
# Plot Figure 4a - Main panel
# -------------------

n_grids = 7
colRB = scales::alpha(colorRampPalette(c("blue",'red'))(n_grids),0.5)

setwd(figureOutputDirectory)
tiff(filename = 'Figure4a_mainPanel.tif', width = 20, height = 20, units = 'cm', res = 300)
par(mar = c(5,5,4,4))
plot(c(1), ylim = c(0.01,1), xlim = c(0,100), type = 'n', 
     ylab = 'Edge / Area ratio', xlab = 'Vegetation cover (%)', 
     log = '', cex.lab = 1.8, cex.axis = 1.7)
for(i_grid in c(1,4,n_grids)){
  y = EA[,i_grid]
  x = A[,i_grid]*100
  fit = smooth.spline(y = y[!is.na(y)], x = x[!is.na(y)], df = 7)
  xSeq = seq(0.1,1,length.out = 1000)*100
  spline = predict(fit, xSeq)$y
  spline[spline <= 0.01] = NA
  lines(spline ~ xSeq, lwd = 2, col = colRB[i_grid])  ## fitted spline
  filter = y >= 0.01
  
  points(y[filter] ~ x[filter], pch = '.', col = alpha(colRB[i_grid],0.5), cex = 3)
}
lines(y = c(0.8,1.02), x= c(0.1,0.1)*100, col = alpha('black',0.2), lwd = 3)
lines(y = c(0.4,0.95), x= c(0.33,0.33)*100, col = alpha('black',0.2), lwd = 3)
lines(y = c(0.15,0.6), x= c(0.66,0.66)*100, col = alpha('black',0.2), lwd = 3)
dev.off()

# Figure 2a sub-panels
col = colorRampPalette(c(terrain.colors(1000)[1000],terrain.colors(1000)[1]))(1000)
setwd(figureOutputDirectory)
tiff(filename = 'Figur34a_subpanel_%04d.tif', width = 20, height = 20, units = 'cm', res = 300)
par(mar = c(0,0,0,0))
for(i_grid in c(1,n_grids)){
  q10 = which.min(abs(A[,i_grid] - 0.1))
  q33 = which.min(abs(A[,i_grid] - 0.33))
  q66 = which.min(abs(A[,i_grid] - 0.66))
  plot(raster::raster(M[,,q10,i_grid]), legend = F, box = F, axes = F)
  plot(raster::raster(M[,,q33,i_grid]), legend = F, box = F, axes = F, col = col)
  plot(raster::raster(M[,,q66,i_grid]), legend = F, box = F, axes = F, col = col)
}
dev.off()

# ------------------
# Load results of simulation - Figure 4b 
# -------------------
setwd(rdaInputDirectory)
load('Figure4b_trial.rda')
load('Figure4b_EdgeAreaRatio_trial.rda')
load('Figure4b_VegetationCover_trial.rda')

# ------------------
# Plot Figure 4b - Main panel
# -------------------

setwd(figureOutputDirectory)
tiff(filename = paste('Figure4b_mainPanel_',disturbanceMoment,'-',disturbanceIntensity,'.tif',sep = ''), width = 20, height = 20, units = 'cm', res = 300)
par(mar = c(5,5,4,4))
plot(c(1), ylim = c(0.01,1), xlim = c(0,100), type = 'n', 
     ylab = 'Edge / Area ratio', xlab = 'Vegetation Cover (%)', 
     log = '', cex.lab = 1.8, cex.axis = 1.7)
for(i_grid in c(1,4,n_grids)){
  y = EA3[,i_grid]
  x = A3[,i_grid]*100
  breakMoment = which(sign(diff(x[!is.na(x)])) == -1)
  y1 = y[!is.na(y)][1:breakMoment]
  x1 = x[!is.na(y)][1:breakMoment]
  filter1 = x1 < disturbanceMoment*100
  y1 = y1[filter1]
  x1 = x1[filter1]
  y2 = y[!is.na(y)][(1+breakMoment):length(x[!is.na(y)])]
  x2 = x[!is.na(y)][(1+breakMoment):length(x[!is.na(y)])]
  
  filter = x1 < disturbanceMoment*100
  points(y1[filter] ~ x1[filter], pch = '.', col = alpha(colRB[i_grid],0.5), cex = 3)
  
  fit1 = smooth.spline(y = y1, x = x1, df = 7)
  xSeq1 = seq(0.1,disturbanceMoment,length.out = 1000)*100
  spline1 = predict(fit1, xSeq1)$y
  lines(spline1 ~ xSeq1, lwd = 3, col = alpha(colRB[i_grid],0.5))  ## fitted spline
  
  if(length(y2) > 10){
    if(i_grid > 4){
      fit2 = smooth.spline(y = y2, x = x2, df = 7)
      xSeq2 = seq(min(x2),100,length.out = 1000)
      spline2 = predict(fit2, xSeq2)$y
      xSeq2 = c(min(x2),seq(min(x2),100,length.out = 1000))
      lines(c(y2[1],spline2) ~ xSeq2, lwd = 3, col = alpha(colRB[i_grid],0.5))  ## fitted spline
    } else {
      
      fit2 = smooth.spline(y = y2, x = x2, df = 15)
      xSeq2 = seq(min(x2),100,length.out = 1000)
      spline2 = predict(fit2, xSeq2)$y
      xSeq2 = c(min(x2),seq(min(x2),100,length.out = 1000))
      lines(c(y2[1],spline2) ~ xSeq2, lwd = 3, col = alpha(colRB[i_grid],0.5))  ## fitted spline
    }
  }
  
  if(length(y2) > 10){
    filter = T
    points(y2[filter] ~ x2[filter], pch = '.', col = alpha(colRB[i_grid],0.5), cex = 3)
  } else {
    points(y1[which.max(x1[filter])] ~ x1[which.max(x1[filter])], pch = 4, col = alpha(colRB[i_grid],0.5), lwd = 3, cex = 1.5)
  }
}
lines(x = c(disturbanceMoment,disturbanceMoment)*100, y = c(0,1), lty = 2, col = grey(0.3), lwd = 3)
text(x = 100*(disturbanceMoment - 0.03), y = 0.86, cex = 1.8, 'Disturbance', srt = 270, col = grey(0.3), lwd = 3)

# ---------------------
# Transparent underlayer of Figure 4a
# ---------------------
for(i_grid in c(1,4,n_grids)){
  y = EA[,i_grid]
  x = A[,i_grid]*100
  fit = smooth.spline(y = y[!is.na(y)], x = x[!is.na(y)], df = 7)
  xSeq = seq(0.1,1,length.out = 1000)*100
  spline = predict(fit, xSeq)$y
  spline[spline <= 0.01] = NA
  lines(spline ~ xSeq, lwd = 2, col = alpha(colRB[i_grid],0.2))  ## fitted spline
  filter = y >= 0.01
  
  points(y[filter] ~ x[filter], pch = '.', col = alpha(colRB[i_grid],0.2), cex = 3)
}
dev.off()


# -------------------------
# Figure 4b sub-panels
# -------------------------
colGW = alpha(colorRampPalette(c(terrain.colors(100)[100],terrain.colors(100)[1]))(1000),1)
setwd(figureOutputDirectory)
tiff(filename = 'Figure4b_subpanels_%04d.tif', width = 20, height = 20, units = 'cm', res = 300)
par(mar = c(0,0,0,0))
for(i_grid in c(1,4,n_grids)){
  disturbanceEvent = which(sign(diff(A3[,i_grid])) == -1)
  qBefore = disturbanceEvent
  qAfter = disturbanceEvent + 1
  
  MBefore = M[,,qBefore,i_grid]
  MAfter = M[,,qAfter,i_grid]

  plot(raster::raster(MBefore), col = colGW, legend = F, box = F, axes = F)
  plot(raster::raster(MAfter), col = colGW, legend = F, box = F, axes = F)
}
dev.off()




# ------------------
# Load results of simulation - Figure 4c 
# -------------------
setwd(rdaInputDirectory)
load('Figure4c_trial.rda')
load('Figure4c_EdgeAreaRatio_trial.rda')
load('Figure4c_VegetationCover_trial.rda')

# ------------------
# Plot Figure 4c - Main panel
# -------------------

setwd(figureOutputDirectory)
tiff(filename = paste('Figure4c_mainPanel_',disturbanceMoment,'-',disturbanceIntensity,'.tif',sep = ''), width = 20, height = 20, units = 'cm', res = 300)
par(mar = c(5,5,4,4))
plot(c(1), ylim = c(0.01,1), xlim = c(0,100), type = 'n', 
     ylab = 'Edge / Area ratio', xlab = 'Vegetation cover (%)', 
     log = '', cex.lab = 1.8, cex.axis = 1.7)
for(i_grid in c(1,4,n_grids)){
  y = EA2[,i_grid]
  x = A2[,i_grid]*100
  breakMoment = which(sign(diff(x[!is.na(x)])) == -1)
  y1 = y[!is.na(y)][1:breakMoment]
  x1 = x[!is.na(y)][1:breakMoment]
  filter1 = x1 < disturbanceMoment*100
  y1 = y1[filter1]
  x1 = x1[filter1]
  y2 = y[!is.na(y)][(1+breakMoment):length(x[!is.na(y)])]
  x2 = x[!is.na(y)][(1+breakMoment):length(x[!is.na(y)])]
  
  filter = x1 < disturbanceMoment*100
  points(y1[filter] ~ x1[filter], pch = '.', col = alpha(colRB[i_grid],0.5), cex = 3)
  
  fit1 = smooth.spline(y = y1, x = x1, df = 3)
  xSeq1 = seq(0.1,disturbanceMoment,length.out = 1000)*100
  spline1 = predict(fit1, xSeq1)$y
  spline1[spline1 <= 0.01] = NA
  lines(spline1 ~ xSeq1, lwd = 3, col = alpha(colRB[i_grid],0.5))  ## fitted spline
  
  if(length(y2) > 10){
    if(i_grid < 2){
      fit2 = smooth.spline(y = y2, x = x2, df = 15)
      xSeq2 = seq(min(x2),100,length.out = 1000)
      spline2 = predict(fit2, xSeq2)$y
      xSeq2 = c(min(x2),seq(min(x2),100,length.out = 1000))
      lines(c(y2[1],spline2) ~ xSeq2, lwd = 3, col = alpha(colRB[i_grid],0.5))  ## fitted spline
    } else {
      
      fit2 = smooth.spline(y = y2, x = x2, df = 10)
      xSeq2 = seq(min(x2),100,length.out = 1000)
      spline2 = predict(fit2, xSeq2)$y
      xSeq2 = c(min(x2),seq(min(x2),100,length.out = 1000))
      lines(c(y2[1],spline2) ~ xSeq2, lwd = 3, col = alpha(colRB[i_grid],0.5))  ## fitted spline
    }
  }
  
  if(length(y2) > 10){
    filter = T
    points(y2[filter] ~ x2[filter], pch = '.', col = alpha(colRB[i_grid],0.5), cex = 3)
  } else {
    points(y1[which.max(x1[filter])] ~ x1[which.max(x1[filter])], pch = 4, col = alpha(colRB[i_grid],0.5), lwd = 3, cex = 1.5)
  }
}
lines(x = c(disturbanceMoment,disturbanceMoment)*100, y = c(0,1), lty = 2, col = grey(0.3), lwd = 3)
text(x = 100*(disturbanceMoment + 0.03), y = 0.86, cex = 1.8, 'Disturbance', srt = 270, col = grey(0.3), lwd = 3)

# ---------------------
# Transparent underlayer of Figure 4a
# ---------------------
for(i_grid in c(1,4,n_grids)){
  y = EA[,i_grid]
  x = A[,i_grid]*100
  fit = smooth.spline(y = y[!is.na(y)], x = x[!is.na(y)], df = 7)
  xSeq = seq(0.1,1,length.out = 1000)*100
  spline = predict(fit, xSeq)$y
  lines(spline ~ xSeq, lwd = 2, col = alpha(colRB[i_grid],0.2))  ## fitted spline
  filter = y >= 0.01
  
  points(y[filter] ~ x[filter], pch = '.', col = alpha(colRB[i_grid],0.2), cex = 3)
}

dev.off()

# -------------------------
# Figure 4c sub-panels
# -------------------------
colGW = alpha(colorRampPalette(c(terrain.colors(100)[100],terrain.colors(100)[1]))(1000),1)
setwd(figureOutputDirectory)
tiff(filename = 'Figure4c_subpanels_%04d.tif', width = 20, height = 20, units = 'cm', res = 300)
par(mar = c(0,0,0,0))
for(i_grid in c(1,4,n_grids)){
  disturbanceEvent = which(sign(diff(A2[,i_grid])) == -1)
  qBefore = disturbanceEvent
  qAfter = disturbanceEvent + 1
  
  MBefore = M[,,qBefore,i_grid]
  MAfter = M[,,qAfter,i_grid]
  
  plot(raster::raster(MBefore), col = colGW, legend = F, box = F, axes = F)
  plot(raster::raster(MAfter), col = colGW, legend = F, box = F, axes = F)
}
dev.off()
